//-----------------------------LICENSE NOTICE------------------------------------
//  This file is part of Outlaws
//  Copyright (C) 2016 RETROBYTES PRODUCTIONS
//
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//------------------------------------------------------------------------------


#include "tilemaps.h"

//EXO_tileset INCLUDES

//unsigned char* const G_tileset[84]
//84 x const unsigned char G_tileset_xxx[4 * 8]
//const u8 G_levelTilemaps[MAX_LEVELS][20*18]


const u8 EXO_tileset[2057] ={
		 0x88, 0x89, 0x88, 0x05, 0x95, 0x89, 0x15, 0x00, 0x00, 0x88, 0x84, 0x59, 0xcd, 0x3c, 0xcd, 0xb2,
		 0x00, 0x00, 0x10, 0x99, 0x98, 0x98, 0x45, 0x2d, 0x00, 0x89, 0x36, 0xf5, 0xfa, 0x6e, 0xba, 0xff,
		 0x54, 0x19, 0x7e, 0xdd, 0xce, 0xee, 0xda, 0xfa, 0x5f, 0xb5, 0xa4, 0x29, 0xf0, 0x2e, 0xe4, 0x64,
		 0xd8, 0x97, 0x98, 0xd5, 0xd5, 0x99, 0x32, 0xa6, 0xed, 0x77, 0xcc, 0x11, 0xe7, 0x7a, 0x49, 0xe9,
		 0x5a, 0xcd, 0xe7, 0xdf, 0x72, 0xa5, 0xd8, 0xce, 0x5a, 0xb9, 0xdc, 0xe4, 0x26, 0x9d, 0xeb, 0x95,
		 0xcc, 0x52, 0x64, 0x95, 0x2c, 0x9a, 0x66, 0x2c, 0x19, 0x98, 0xae, 0x99, 0x44, 0x85, 0x5c, 0x21,
		 0x95, 0x44, 0x01, 0x13, 0x2d, 0x58, 0xb2, 0x99, 0x51, 0x47, 0x0c, 0xf0, 0xc0, 0xbe, 0x45, 0xce,
		 0x94, 0x77, 0x0b, 0x0c, 0x0a, 0x99, 0x98, 0x0c, 0x38, 0x24, 0x33, 0xb2, 0xcf, 0x09, 0xdc, 0x05,
		 0x39, 0x03, 0x0d, 0x55, 0x98, 0x52, 0x9b, 0x68, 0xad, 0xcd, 0x58, 0x30, 0xc3, 0x00, 0x0b, 0x89,
		 0xd7, 0xdc, 0xee, 0xeb, 0x6a, 0x70, 0xdd, 0x45, 0xba, 0x45, 0xe4, 0x2d, 0xf0, 0x26, 0x89, 0x4c,
		 0xa5, 0xfa, 0xba, 0x01, 0xf5, 0xc9, 0x77, 0xba, 0xf6, 0x0f, 0xb4, 0x2a, 0xff, 0x91, 0x29, 0xcc,
		 0xf8, 0x70, 0x66, 0x76, 0xd0, 0x98, 0x5c, 0xfa, 0x2f, 0x7b, 0x75, 0x30, 0x5d, 0xdd, 0xb5, 0x50,
		 0xb5, 0x64, 0x96, 0xda, 0xe4, 0xae, 0xf4, 0xf9, 0xb2, 0x58, 0xf0, 0xf5, 0x25, 0xab, 0x9d, 0x72,
		 0x3c, 0x36, 0xb5, 0x75, 0x56, 0x78, 0x54, 0xd3, 0xba, 0xa3, 0xae, 0x38, 0xa8, 0x77, 0x61, 0xe4,
		 0x75, 0x17, 0x44, 0xfe, 0x82, 0xfd, 0xa5, 0xb9, 0xb8, 0x96, 0x2b, 0x76, 0x74, 0xd5, 0x57, 0xdf,
		 0x32, 0x70, 0xd5, 0xbb, 0x59, 0xaf, 0xed, 0x0c, 0x2c, 0xae, 0x57, 0xc3, 0xf7, 0x49, 0x34, 0x69,
		 0x6a, 0x74, 0x9c, 0xb5, 0x30, 0xaa, 0xf4, 0x59, 0xac, 0x5c, 0x6b, 0x6f, 0x86, 0xbb, 0x4d, 0xc3,
		 0xc5, 0x9a, 0x30, 0x8e, 0xb6, 0x5c, 0x16, 0x57, 0x5d, 0x5f, 0xfe, 0x7c, 0xcb, 0x92, 0xfd, 0xe9,
		 0xc7, 0xd7, 0x4f, 0x5e, 0x4f, 0x61, 0x56, 0x49, 0xd3, 0x0d, 0x8d, 0xac, 0x7b, 0x86, 0x5d, 0xfd,
		 0x61, 0x74, 0x6d, 0x30, 0x33, 0xba, 0xdc, 0x86, 0x25, 0x83, 0xd6, 0xe4, 0xd2, 0xe9, 0x63, 0x9d,
		 0x77, 0x7b, 0x9f, 0xf0, 0x3e, 0x47, 0xaa, 0x74, 0xca, 0x30, 0x88, 0x53, 0x02, 0x6b, 0x8e, 0xd5,
		 0x8e, 0x92, 0x58, 0x07, 0x6b, 0xf4, 0x89, 0xc5, 0x65, 0x05, 0x24, 0x56, 0x66, 0xdb, 0xad, 0x68,
		 0x59, 0xaf, 0xb2, 0xd5, 0x68, 0x5d, 0x5e, 0x22, 0x4d, 0x5f, 0xb6, 0x22, 0x7e, 0x47, 0x5e, 0x1a,
		 0x03, 0x6d, 0xaf, 0x3b, 0x47, 0xeb, 0xb5, 0x68, 0xac, 0xe4, 0x86, 0x44, 0x6d, 0x62, 0x36, 0xf8,
		 0x24, 0x58, 0x68, 0xac, 0x0d, 0xf0, 0xfe, 0xe0, 0xb0, 0x16, 0x4d, 0xe4, 0x56, 0x44, 0x57, 0xd8,
		 0x5a, 0x56, 0x64, 0x92, 0xa0, 0x85, 0xb9, 0x30, 0xb2, 0xcc, 0x12, 0x06, 0xc1, 0x70, 0x38, 0xee,
		 0x49, 0xa2, 0x30, 0xc1, 0x43, 0x66, 0xfb, 0xc2, 0xac, 0x21, 0x4f, 0xf6, 0xfd, 0x1d, 0x1d, 0x64,
		 0xb2, 0x87, 0x5a, 0xc9, 0x87, 0x50, 0x10, 0xe8, 0x31, 0xab, 0x86, 0x80, 0xad, 0x68, 0xa4, 0xe0,
		 0x60, 0x0f, 0xce, 0x50, 0xd2, 0x75, 0xcc, 0xd0, 0xc8, 0x72, 0xd8, 0x88, 0x46, 0xef, 0x23, 0xd9,
		 0x98, 0x44, 0x68, 0xcb, 0xcc, 0xcd, 0x30, 0x44, 0x61, 0x80, 0x84, 0xac, 0x24, 0xb0, 0xc4, 0x9c,
		 0x1a, 0x38, 0x9a, 0xe4, 0x26, 0x87, 0x28, 0x26, 0xf2, 0xe0, 0x3b, 0x2c, 0xe9, 0xc0, 0x82, 0x45,
		 0x0f, 0x0d, 0x13, 0x77, 0x0d, 0x57, 0xe0, 0x1c, 0xcc, 0x14, 0xe4, 0x2c, 0x7d, 0x50, 0x13, 0x78,
		 0x11, 0xc0, 0x45, 0xc2, 0x70, 0x45, 0x00, 0xf1, 0xf0, 0x02, 0x2f, 0x0b, 0x26, 0x07, 0x7e, 0xd4,
		 0x70, 0x00, 0xbc, 0xe0, 0x8a, 0x76, 0xce, 0xcb, 0xef, 0x9b, 0x2b, 0xed, 0x77, 0x7f, 0xba, 0x67,
		 0xde, 0xfd, 0xb9, 0xcf, 0xa9, 0xfe, 0xda, 0xb0, 0x98, 0x9a, 0x66, 0xdf, 0x74, 0xb9, 0x9b, 0xfe,
		 0xb9, 0x9f, 0xed, 0xd7, 0x66, 0xef, 0xbb, 0x48, 0xaf, 0xdf, 0xcd, 0xcf, 0x67, 0xfc, 0x65, 0xdc,
		 0xde, 0xed, 0xb9, 0x6f, 0x9b, 0xfd, 0xee, 0xef, 0x53, 0xb8, 0xad, 0xdd, 0x76, 0x6a, 0xea, 0xa7,
		 0x35, 0x9b, 0xd7, 0xfd, 0xef, 0xcf, 0xb8, 0xeb, 0xf0, 0xed, 0xbb, 0x75, 0x67, 0xbd, 0xfe, 0xb4,
		 0xdd, 0xae, 0x76, 0x7e, 0x31, 0x65, 0x79, 0xcd, 0x67, 0xfd, 0xef, 0x74, 0x95, 0xde, 0x9d, 0xb9,
		 0xe9, 0xa7, 0x64, 0x65, 0x41, 0x3d, 0xd6, 0x77, 0x5b, 0xef, 0x7e, 0xde, 0xcf, 0xb8, 0x9b, 0x9e,
		 0x77, 0xf2, 0xfd, 0xce, 0xdf, 0xdc, 0xaf, 0xbb, 0xba, 0xcf, 0x75, 0xb5, 0x31, 0xff, 0x00, 0x10,
		 0x12, 0xfb, 0x34, 0xf7, 0x24, 0xf3, 0x46, 0x41, 0xa0, 0x35, 0x11, 0x47, 0xa2, 0x45, 0x3f, 0xbf,
		 0x09, 0xa6, 0x85, 0xeb, 0x04, 0x73, 0xce, 0x05, 0xa2, 0x85, 0x29, 0xd9, 0x23, 0x44, 0x37, 0xea,
		 0xbf, 0x54, 0xcb, 0x1a, 0x87, 0x20, 0xc0, 0x26, 0x88, 0xd7, 0xfa, 0xa2, 0xdd, 0xe2, 0xbe, 0x3c,
		 0x78, 0x2a, 0x25, 0xd1, 0xf2, 0x38, 0x57, 0xee, 0x2b, 0xb6, 0xab, 0x92, 0xae, 0x49, 0xa8, 0x7f,
		 0xd8, 0x0c, 0xef, 0x7a, 0x5d, 0x4d, 0xc5, 0xee, 0xe4, 0xdf, 0xdd, 0xf0, 0xb4, 0x3c, 0x7d, 0x48,
		 0x8e, 0x96, 0xab, 0x70, 0x57, 0x5f, 0x43, 0xdc, 0xfb, 0xae, 0xc3, 0x7a, 0x8e, 0x5d, 0xc5, 0xbf,
		 0x26, 0xda, 0x5a, 0xee, 0x57, 0xa5, 0xb2, 0x55, 0xa1, 0xa9, 0xe5, 0x22, 0xb2, 0x67, 0x50, 0x2d,
		 0x6d, 0xcf, 0x34, 0xdd, 0xb0, 0xf2, 0xbc, 0x59, 0x10, 0xd9, 0x77, 0xf5, 0xfb, 0x55, 0x26, 0xad,
		 0x9a, 0xa5, 0xda, 0x9a, 0x33, 0x15, 0x67, 0x2a, 0xa7, 0x35, 0x9e, 0x0e, 0x7a, 0xde, 0xe0, 0x79,
		 0x73, 0x34, 0xc4, 0x98, 0xf7, 0x1d, 0xc6, 0x30, 0xd8, 0xba, 0x44, 0x14, 0x30, 0x72, 0xfa, 0xea,
		 0xd7, 0xbe, 0x71, 0xb0, 0xf0, 0x32, 0xba, 0xcf, 0x56, 0x66, 0x59, 0x65, 0xd6, 0x48, 0x2e, 0x74,
		 0x75, 0x7a, 0xcc, 0xdd, 0xe4, 0xe1, 0x5b, 0x5d, 0x36, 0x6c, 0xf7, 0xff, 0x46, 0x4a, 0x88, 0xd4,
		 0x14, 0x2d, 0xa5, 0x3f, 0x2f, 0x7f, 0x52, 0x54, 0xd2, 0x2c, 0x79, 0x38, 0xa3, 0x0a, 0xd4, 0xc0,
		 0x0d, 0x14, 0x2f, 0x2b, 0x03, 0x5f, 0xec, 0xfc, 0xaa, 0xfe, 0x12, 0xd1, 0x92, 0x8a, 0xc8, 0xe8,
		 0x52, 0xb8, 0x4b, 0x0c, 0x47, 0x3f, 0x7f, 0xb5, 0x0e, 0x3b, 0x47, 0xc5, 0xc1, 0xb5, 0xa4, 0x67,
		 0x60, 0x7a, 0x7e, 0xee, 0x22, 0x1b, 0xdd, 0x36, 0xbf, 0xcc, 0x68, 0x25, 0x0c, 0x9c, 0x63, 0x61,
		 0x23, 0x64, 0xee, 0x97, 0xda, 0xdd, 0x57, 0x4a, 0x50, 0x60, 0xa5, 0x5f, 0x9a, 0x1b, 0xf3, 0xf5,
		 0xf0, 0x66, 0x03, 0x67, 0xae, 0xb1, 0xb0, 0x7d, 0xef, 0x75, 0x22, 0x47, 0x30, 0x47, 0x3d, 0xa3,
		 0x25, 0x74, 0x66, 0xa6, 0x02, 0x32, 0x68, 0xa4, 0xba, 0x6f, 0xd7, 0xf5, 0x65, 0x92, 0x26, 0x63,
		 0x9a, 0x73, 0x21, 0xbd, 0x59, 0x4e, 0x47, 0x82, 0x89, 0xcf, 0x14, 0x66, 0xb5, 0x60, 0x92, 0x05,
		 0x5f, 0x47, 0x92, 0x77, 0xf5, 0x1b, 0x32, 0x25, 0x13, 0x9b, 0x69, 0x97, 0x04, 0x13, 0x33, 0x29,
		 0x50, 0x41, 0x32, 0x26, 0x21, 0xaf, 0xb8, 0xdb, 0x67, 0x10, 0x8f, 0x59, 0xbb, 0x74, 0x21, 0x03,
		 0x2d, 0x85, 0xe9, 0x71, 0x33, 0x3b, 0x2c, 0x33, 0xac, 0x1d, 0x85, 0x7a, 0x4c, 0x21, 0x21, 0x92,
		 0xb5, 0x9a, 0xb9, 0x65, 0x9e, 0xc8, 0xcf, 0x6d, 0xfa, 0x56, 0x34, 0xff, 0x0b, 0xeb, 0x67, 0xc2,
		 0xec, 0x2e, 0xa7, 0x97, 0x47, 0x63, 0x74, 0x9d, 0xc9, 0x7d, 0x5e, 0x6e, 0x46, 0xfd, 0x5a, 0x9b,
		 0xad, 0x59, 0x4b, 0x77, 0x7d, 0x70, 0x3c, 0x41, 0x1d, 0x5d, 0x34, 0x34, 0xe8, 0x8b, 0x38, 0xae,
		 0xd4, 0x9a, 0xf4, 0xfd, 0xdd, 0x86, 0x5b, 0x7d, 0xf5, 0x4a, 0x0a, 0x4b, 0x40, 0xd7, 0xda, 0x68,
		 0x59, 0xf7, 0x58, 0xce, 0x3f, 0x2e, 0xad, 0xbe, 0x1d, 0x1a, 0x1b, 0x26, 0xea, 0xd2, 0x8a, 0x0c,
		 0x81, 0xe2, 0xd3, 0x0a, 0x4c, 0x2b, 0x4e, 0xba, 0xfa, 0x75, 0x77, 0x4b, 0x12, 0xeb, 0xb4, 0x38,
		 0x4a, 0x3c, 0xeb, 0xbe, 0xdd, 0xfc, 0xed, 0xfe, 0xf5, 0xfa, 0xa5, 0x98, 0xe4, 0xd5, 0xb4, 0x57,
		 0x70, 0xf0, 0x38, 0xa7, 0xb0, 0x77, 0x4f, 0xc8, 0xfd, 0x64, 0x97, 0x6d, 0x6c, 0x56, 0x77, 0x75,
		 0xd3, 0x46, 0x37, 0xed, 0xf5, 0xba, 0x65, 0x95, 0x7d, 0xbe, 0x76, 0x75, 0xf5, 0x5f, 0xaf, 0x90,
		 0x7b, 0xfa, 0x8e, 0xf2, 0x72, 0xc0, 0x2d, 0xd1, 0xba, 0x7e, 0xb4, 0x8d, 0xfd, 0x78, 0x89, 0xe4,
		 0x13, 0x0a, 0x6d, 0x7d, 0xaf, 0x32, 0xb6, 0xe4, 0x76, 0x66, 0x6d, 0xf6, 0xfc, 0x3c, 0xb4, 0x6d,
		 0xbe, 0xf0, 0x1b, 0xd8, 0x50, 0xee, 0xd5, 0xb0, 0xfb, 0xbd, 0x40, 0xe7, 0xa0, 0xf3, 0xef, 0x0c,
		 0x8d, 0x67, 0x09, 0x9b, 0x12, 0x33, 0x68, 0xab, 0x99, 0x25, 0xff, 0xa9, 0xb1, 0xcd, 0x7c, 0x75,
		 0xdf, 0xe5, 0x73, 0xce, 0x4c, 0x23, 0xb1, 0xb6, 0x66, 0x33, 0xa7, 0x37, 0xcf, 0xcd, 0x67, 0x1b,
		 0x16, 0x65, 0x9e, 0xa9, 0xdf, 0x35, 0x28, 0x34, 0x4b, 0xda, 0x70, 0xd5, 0xff, 0xa5, 0x38, 0x98,
		 0x2a, 0x6f, 0xd0, 0x28, 0xae, 0x64, 0xba, 0xd8, 0xa8, 0xf0, 0x6f, 0xb0, 0xbb, 0xef, 0xa0, 0x1a,
		 0xa7, 0xff, 0x54, 0x77, 0xcd, 0xba, 0x79, 0x6d, 0xfa, 0x99, 0x72, 0xbc, 0xce, 0xbe, 0x70, 0x5b,
		 0x39, 0x98, 0xc7, 0xff, 0x8e, 0xa7, 0x64, 0x1c, 0xa5, 0xee, 0x94, 0xe2, 0x48, 0x49, 0x8c, 0x6f,
		 0x08, 0x09, 0x0c, 0x0d, 0x66, 0x9a, 0xd9, 0x4a, 0x19, 0x4b, 0xdf, 0x0a, 0x0b, 0x0e, 0x0f, 0xcc,
		 0x34, 0xb3, 0x1b, 0x30, 0x31, 0x1f, 0x34, 0x35, 0x00, 0x01, 0x8e, 0x1b, 0x32, 0x33, 0x1f, 0x36,
		 0x37, 0x02, 0x03, 0x8e, 0xbb, 0x40, 0x41, 0xfe, 0x38, 0x39, 0x24, 0x25, 0x43, 0x04, 0x05, 0x71,
		 0x42, 0x43, 0xd7, 0x7f, 0x3a, 0x3b, 0x26, 0x27, 0x06, 0x07, 0x28, 0xce, 0x44, 0x45, 0x81, 0x8f,
		 0x3c, 0x3d, 0xda, 0xd1, 0xb8, 0xe7, 0x46, 0x47, 0xc0, 0x47, 0x3e, 0x3f, 0xed, 0x68, 0xdc, 0x2e,
		 0x32, 0xb2, 0xd9, 0x6c, 0xf4, 0x20, 0x87, 0xea, 0x22, 0x23, 0x9b, 0xcd, 0x46, 0x0f, 0x72, 0xa8,
		 0xac, 0xc6, 0xa3, 0x76, 0xdf, 0x65, 0x0e, 0x95, 0xd5, 0x78, 0xd4, 0xee, 0xbb, 0xcc, 0xa1, 0xc2,
		 0x93, 0x75, 0x1f, 0x0d, 0x19, 0x9e, 0xac, 0xfb, 0x68, 0xc8, 0x4e, 0x41, 0xed, 0x8c, 0x4e, 0x41,
		 0xed, 0x8c, 0x78, 0x2d, 0x99, 0x65, 0x64, 0x16, 0xaf, 0x25, 0xb3, 0x8c, 0xcc, 0x0e, 0x20, 0x21,
		 0x24, 0x0e, 0x22, 0x23, 0x24, 0x6e, 0x50, 0x51, 0x9c, 0x4c, 0x4d, 0x49, 0x94, 0x66, 0xd1, 0x52,
		 0x8d, 0x53, 0x33, 0x4e, 0x4f, 0x89, 0xd2, 0x2c, 0x0a, 0xf8, 0x81, 0x3e, 0x18, 0x19, 0x1c, 0x1d,
		 0xdc, 0xc8, 0xa2, 0x0f, 0x1a, 0x1b, 0x1e, 0x1f, 0x37, 0xb2, 0xa8, 0x83, 0x68, 0x84, 0x96, 0x38,
		 0xe9, 0xa6, 0x83, 0x68, 0x84, 0x96, 0x38, 0xe9, 0xa6, 0xc3, 0x8c, 0x50, 0x33, 0xa3, 0xc3, 0x8c,
		 0x50, 0x33, 0x23, 0xb7, 0x55, 0x70, 0xe4, 0xb6, 0x0a, 0x8e, 0xa8, 0xcf, 0x2c, 0xa1, 0x2d, 0xb4,
		 0x5d, 0xd4, 0xe7, 0x2e, 0x2f, 0x50, 0xda, 0xee, 0x28, 0x29, 0xc6, 0x14, 0xa1, 0x15, 0xc8, 0xa2,
		 0x1b, 0x2a, 0x2b, 0x87, 0x16, 0x17, 0x22, 0x8b, 0x72, 0x9e, 0xf0, 0x3a, 0xe3, 0x75, 0x85, 0xd7,
		 0x99, 0xd1, 0x29, 0x1a, 0x29, 0x34, 0x56, 0xb6, 0xa2, 0x91, 0x32, 0x8b, 0xf3, 0xf0, 0x64, 0x71,
		 0x1e, 0x9e, 0x2c, 0xce, 0xa3, 0xa9, 0x9a, 0x67, 0x10, 0x11, 0x1e, 0x9e, 0xaa, 0x79, 0x12, 0x13,
		 0x9c, 0x37, 0xe2, 0x79, 0x5b, 0xb3, 0x43, 0xe6, 0xd9, 0x0a, 0xcd, 0xd5, 0x6d, 0x94, 0x07, 0xfc,
		 0xba, 0x72, 0x27, 0xf5, 0x9d, 0xa0, 0xcd, 0x91, 0x3b, 0x29, 0x5e, 0x7c, 0xa6, 0xd1, 0x7c, 0x69,
		 0x74, 0x0c, 0xf1, 0xfc, 0x1d, 0xa6, 0xd1, 0x31, 0xc4, 0xf3, 0xf7, 0xa1, 0x7c, 0x70, 0x51, 0x12,
		 0x1a, 0x2d, 0x1f, 0x5c, 0x94, 0xc4, 0xa3, 0xa5, 0x31, 0xe9, 0xe0, 0xa2, 0x24, 0xbe, 0x2b, 0x8d,
		 0x49, 0x07, 0x17, 0x25, 0xf1, 0x5d, 0x79, 0x4c, 0x28, 0xa2, 0xbb, 0xf2, 0x98, 0x50, 0x44, 0x77,
		 0x85, 0x8e, 0xcd, 0x7b, 0xa3, 0xbb, 0x42, 0xc7, 0xe6, 0xbd, 0x81, 0xdc, 0xd5, 0xeb, 0x81, 0xdc,
		 0x15, 0x0f, 0x9a, 0x7d, 0x83, 0xef, 0xce, 0xbe, 0xe1, 0x88, 0xef, 0x8a, 0xef, 0x89, 0xf3, 0x5c,
		 0x57, 0x74, 0x47, 0x9c, 0x07, 0x78, 0x57, 0x7c, 0x4c, 0x9c, 0x64, 0x2b, 0x3e, 0x26, 0x4e, 0xa2,
		 0x56, 0x80, 0x77, 0x85, 0xf6, 0x40, 0x4b, 0x7c, 0x57, 0x68, 0x0f, 0xb4, 0x64, 0x51, 0xee, 0xb2,
		 0xf0, 0x76, 0x88, 0x77, 0x5d, 0x78, 0x3b, 0x64, 0x51, 0x36, 0xc3, 0x2b, 0xcb, 0x76, 0x36, 0xc3,
		 0x2b, 0xcb, 0x76, 0xdc, 0x0c, 0xb7, 0xe3, 0x66, 0xb8, 0x1d, 0x7f, 0xec, 0xe1, 0x97, 0x17, 0x7f,
		 0xec, 0xe1, 0x97, 0x17, 0x7e, 0x6c, 0x99, 0x06, 0x3f, 0xb6, 0x38, 0x0d, 0x3f, 0x82, 0xf8, 0x49,
		 0x85, 0x1f, 0x41, 0xfc, 0xa4, 0xa2, 0x63, 0xe2, 0x34, 0x1a, 0x24, 0x3a, 0x26, 0x4e, 0xa3, 0x41,
		 0x3a, 0x88, 0x23, 0x6a, 0xe7, 0x20, 0x1d, 0xc4, 0x11, 0xb5, 0x73, 0x90, 0x4e, 0x79, 0x7b, 0xf8,
		 0xca, 0x46, 0xa7, 0xbc, 0x3d, 0x74, 0x65, 0xfc, 0xa4, 0xc2, 0x4f, 0x3f, 0xbb, 0x66, 0xff, 0xf0,
		 0xd3, 0xef, 0x51, 0x80, 0x77, 0xe5, 0x5a, 0xd2, 0xb2, 0x30, 0xb4, 0x9d, 0x6b, 0x49, 0xcb, 0xc2,
		 0xd0, 0x76, 0x96, 0xe7, 0xa5, 0xa1, 0xa4, 0xed, 0x2c, 0xcf, 0x4b, 0x43, 0x49, 0xdb, 0x79, 0x54,
		 0x5e, 0x1a, 0x4a, 0xda, 0xe5, 0x51, 0x79, 0x69, 0x28, 0x69, 0x97, 0x47, 0x05, 0x45, 0xbb, 0x3c,
		 0x2a, 0x28, 0xda, 0xe5, 0x51, 0xc1, 0x91, 0x47, 0x05, 0x47, 0xf0, 0x76, 0xcc, 0xb3, 0x82, 0xb7,
		 0x63, 0x9e, 0x15, 0x7c, 0x49, 0x66, 0xc1, 0x97, 0x64, 0x16, 0xd4, 0x0c, 0x6e, 0x85, 0x7e, 0xf0,
		 0xf8, 0x96, 0xf0, 0xdd, 0xf1, 0x2d, 0xa1, 0xbb, 0x03, 0xbc, 0x2b, 0xbe, 0x35, 0x7c, 0x5f, 0x7c,
		 0x6b, 0xf8, 0xbe, 0xb8, 0x16, 0x3c, 0x50, 0xf0, 0x37, 0x11, 0xf0, 0xa3, 0xc5, 0x0f, 0x22, 0x1e,
		 0x2c, 0xfe, 0x8c, 0xe2, 0x81, 0xe2, 0x87, 0x12, 0x3f, 0x88, 0xf8, 0x8b, 0xcd, 0xa2, 0xf8, 0x41,
		 0xc4, 0x5f, 0x6c, 0x16, 0xe5, 0x5a, 0xc2, 0x3b, 0x23, 0x7a, 0x59, 0x8d, 0xf0, 0xce, 0xc8, 0xa2,
		 0xf0, 0x57, 0x17, 0x9f, 0x16, 0xfe, 0xea, 0xe2, 0xd3, 0xe2, 0xcb, 0x72, 0x9f, 0xc5, 0x11, 0x5f,
		 0x96, 0xfb, 0x2c, 0x8e, 0xb8, 0x12, 0x0f, 0x9c, 0x49, 0x5c, 0x89, 0x07, 0xce, 0x24, 0xae, 0x84,
		 0x1f, 0x7c, 0x5c, 0x09, 0x3f, 0xf8, 0xa8, 0x12, 0xb7, 0xa2, 0x88, 0x2a, 0x71, 0x2b, 0x23, 0xef,
		 0x0a, 0x24, 0xf2, 0x82, 0xe0, 0x88, 0x26, 0x0d, 0xbf, 0xba, 0xf8, 0x9f, 0x0a, 0xbf, 0xba, 0xb6,
		 0x83, 0xf7, 0x50, 0xbc, 0xb3, 0x82, 0x23, 0x00, 0x80
};

const Prop levelProps[MAX_LEVELS + 2][MAX_ENEMIES] = {

		{{12, 50, ENEMY_TYPE_BARREL}, {25, 86, ENEMY_TYPE_BARREL}, {55, 20, ENEMY_TYPE_CACTUS}, {62, 28, ENEMY_TYPE_MUROPIEDRA}, {69, 28, ENEMY_TYPE_MUROPIEDRA}},
		{{2, 14, ENEMY_TYPE_MUROMADERA}, {12, 14, ENEMY_TYPE_MUROMADERA}, {36, 64, ENEMY_TYPE_MUROPIEDRA}, {MAX_X - 20, 14, ENEMY_TYPE_MUROMADERA}, {MAX_X - 10, 14, ENEMY_TYPE_MUROMADERA}},
		{{24, 14, ENEMY_TYPE_MURO}, {48, 14, ENEMY_TYPE_MURO}, {25, 74, ENEMY_TYPE_BARREL}, {65, 74, ENEMY_TYPE_BARREL}, {36, 8, ENEMY_TYPE_CACTUS}},
		{{2, 34, ENEMY_TYPE_BARREL}, {50, 83, ENEMY_TYPE_BARREL}, {9, 84, ENEMY_TYPE_BARREL}, {15, 84, ENEMY_TYPE_BARREL}, {2, 80, ENEMY_TYPE_CACTUS}},
		{{16, 15, ENEMY_TYPE_MUROMADERA}, {26, 15, ENEMY_TYPE_MUROMADERA}, {36, 15, ENEMY_TYPE_MUROMADERA}, {46, 15, ENEMY_TYPE_MUROMADERA}, {56, 15, ENEMY_TYPE_MUROMADERA}},
		{{8, 46, ENEMY_TYPE_MURO}, {32, 46, ENEMY_TYPE_MURO}, {5, 76, ENEMY_TYPE_BARREL}, {11, 76, ENEMY_TYPE_BARREL}, {50, 95, ENEMY_TYPE_MUROPIEDRA}},
		{{12, 50, ENEMY_TYPE_BARREL}, {25, 86, ENEMY_TYPE_BARREL}, {65, 84, ENEMY_TYPE_CACTUS}, {40, 50, ENEMY_TYPE_BARREL}, {20, 50, ENEMY_TYPE_BARREL}},
		{{0, 15, ENEMY_TYPE_MUROPIEDRA}, {12, 15, ENEMY_TYPE_MUROMADERA}, {36, 79, ENEMY_TYPE_MUROPIEDRA}, {MAX_X - 26, 15, ENEMY_TYPE_MUROMADERA}, {MAX_X - 11, 15, ENEMY_TYPE_MUROMADERA}},
		{{8, 32, ENEMY_TYPE_MURO}, {MAX_X - 15, 13, ENEMY_TYPE_MURO}, {MAX_X - 4, 12, ENEMY_TYPE_BARREL}, {22, 93, ENEMY_TYPE_CACTUS}, {58, 93, ENEMY_TYPE_CACTUS}},
		{{19, 26, ENEMY_TYPE_BOTTLE}, {50, 70, ENEMY_TYPE_BOTTLE}, {60, 35, ENEMY_TYPE_BOTTLE}, {65, 35, ENEMY_TYPE_BOTTLE}, {15, 80, ENEMY_TYPE_BOTTLE}},
		{{10, 74, ENEMY_TYPE_BARREL}, {20, 74, ENEMY_TYPE_BARREL}, {30, 74, ENEMY_TYPE_BARREL}, {40, 74, ENEMY_TYPE_BARREL}, {50, 74, ENEMY_TYPE_BARREL}}

};

const Respawn levelRespawns[MAX_LEVELS][MAX_RESPAWNS] = {

	{{ENEMY_TYPE_LEJOS, {MAX_X + 6, ENEMY_LEJOS_H + 4}, - 1},{ENEMY_TYPE_CERCA, {MIN_X - ENEMY_CERCA_W, 40}, 1},{ENEMY_TYPE_CERCA, {MIN_X - ENEMY_CERCA_W, 72}, 1}, {ENEMY_TYPE_CERCA,{MAX_X, 72}, -1}},
	{{ENEMY_TYPE_LEJOS, {MAX_X + 6, 6}, - 1},{ENEMY_TYPE_CERCA, {MIN_X - ENEMY_CERCA_W, 30}, 1},{ENEMY_TYPE_CERCA, {MIN_X - ENEMY_CERCA_W, 50}, 1}, {ENEMY_TYPE_CERCA,{MAX_X, 50}, -1}},
	{{ENEMY_TYPE_LEJOS, {48, 6}, -1},{ENEMY_TYPE_LEJOS, {25, MIN_Y + 6}, 1},{ENEMY_TYPE_CERCA, {16, 64}, 1}, {ENEMY_TYPE_CERCA,{55, 64}, -1}},
	{{ENEMY_TYPE_LEJOS, {MAX_X - 14, ENEMY_LEJOS_H + 4}, - 1},{ENEMY_TYPE_CERCA, {MIN_X - ENEMY_CERCA_W, 54}, 1},{ENEMY_TYPE_CERCA, {MIN_X - ENEMY_CERCA_W, 72}, 1}, {ENEMY_TYPE_CERCA,{MAX_X, 72}, -1}},
	{{ENEMY_TYPE_LEJOS, {MAX_X + 6, 6}, - 1},{ENEMY_TYPE_CERCA, {MIN_X - ENEMY_CERCA_W, 30}, 1},{ENEMY_TYPE_CERCA, {MIN_X - ENEMY_CERCA_W, 50}, 1}, {ENEMY_TYPE_CERCA,{MAX_X, 50}, -1}},
	{{ENEMY_TYPE_LEJOS, {10, 40}, 1},{ENEMY_TYPE_LEJOS, {32, 40}, -1},{ENEMY_TYPE_CERCA, {MIN_X - ENEMY_CERCA_W, 66}, 1}, {ENEMY_TYPE_CERCA,{MAX_X, 66}, -1}},
	{{ENEMY_TYPE_CERCA, {MAX_X + 6, 40}, - 1},{ENEMY_TYPE_CERCA, {MIN_X - ENEMY_CERCA_W, 40}, 1},{ENEMY_TYPE_CERCA, {MIN_X - ENEMY_CERCA_W, 72}, 1}, {ENEMY_TYPE_CERCA,{MAX_X, 72}, -1}},
	{{ENEMY_TYPE_LEJOS, {MIN_X - ENEMY_LEJOS_W, 6}, 1},{ENEMY_TYPE_CERCA, {MIN_X - ENEMY_CERCA_W, 30}, 1},{ENEMY_TYPE_CERCA, {MIN_X - ENEMY_CERCA_W, 50}, 1}, {ENEMY_TYPE_CERCA,{MAX_X, 50}, -1}},
	{{ENEMY_TYPE_LEJOS, {12, 20}, 1},{ENEMY_TYPE_LEJOS, {MAX_X - 16, 8}, -1},{ENEMY_TYPE_CERCA, {40, 64}, 1}, {ENEMY_TYPE_CERCA,{40, 64}, -1}}

};

const Respawn windowRespawns[3][MAX_WINDOW_ENEMIES] = {

	{{ENEMY_TYPE_WINDOW, {18, 21}, 0}, {0,{0, 0}, 0}, {0,{0, 0}, 0}},
	{{ENEMY_TYPE_WINDOW, {18, 37}, 0}, {ENEMY_TYPE_WINDOW,{34, 37}, 0}, {0,{0, 0}, 0}},
	{{ENEMY_TYPE_WINDOW, {26, 21}, 0}, {ENEMY_TYPE_WINDOW,{42, 21}, 0}, {ENEMY_TYPE_WINDOW,{58, 21}, 0}}

};
